﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using InfoWorld.HL7.ITS;
using SC = BMS.DataContracts;
using FC = BMS.Facade.Data;
using BMS.Facade.Translators;
using BMS.ServicesWrapper.BMService;

namespace BMS.Workflows.CustomActivities
{
    public class UpdateTransferRequest : CodeActivity
    {
        public InArgument<FC.Transfer> TransferRequest { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SC.Transfer transfer = this.TransferRequest.Get<FC.Transfer>(context).ToDataContract();
                transfer.FlowId = context.WorkflowInstanceId;
                BMSFactory.BedManagerOperationsClientFromWCF.UpdateTransfer(transfer);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
